define(['angular', 'app', 'GoalsRemindersService', 'modalService', 'formatter'], function(angular, app) {
	'use strict';

	app.controller('GoalsEntryController', function($scope, $state, $stateParams, $q, modalService,
		focusService, HomePageConstants, formatter, $timeout, GoalsRemindersService, ReflectionsService) {

		$scope.details = {
			goal: {},
			reminder: {
				eventDate: null
			}
		};

		var service = GoalsRemindersService;
		$scope.entryForm = {
			service: service,
			callbacks: {
				allowSave: function() {
					return $scope.allowSavePromise();
				},
				save: function() {
					$state.go("^");
				},
				cancel: function() {
					$state.go("^");
				},
				delete: function() {
					$state.go("^");
				}
			},
			allowedActions: {
				save: !!$scope.details.goal && !$scope.details.goal.completedFlag,
				delete: !!$scope.details.goal && !!$scope.details.goal.meta,
				cancel: true
			}
		};
		ReflectionsService.get();
		$scope.reflectionsDataPointers = ReflectionsService.dataPointers;
		$scope.visionPrompt = 'Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals.';

		if ($stateParams.id) {
			service.getById($stateParams.id).then(function(response) {
				$scope.details.goal = response.goal.resource;
				$scope.details.reminder = response.reminder;
				$scope.details.goal.status === "Complete" ? $scope.details.completedFlag = true : $scope.details.completedFlag = false;
				$scope.entryForm.allowedActions.save = !$scope.details.goal.completedFlag;
				$scope.entryForm.allowedActions.delete = true;
			}, function() {
				$stateParams.id = null;
				$state.go($state.current.name, $stateParams, {
					reload: true
				});
			});
		} else {
			$scope.details = service.createEmpty();
			$scope.entryForm.allowedActions.save = true;
			$scope.entryForm.allowedActions.delete = false;
		}

		$scope.progress = {
			newProgress: null
		};

		$scope.errorHandling = {
			'dueWithinStartEndDate': {
				message: 'Step Due Dates must fall within or on the Goal’s Start Date and End Date range.',
				priority: 1
			},
			'chronological': {
				message: 'Steps must be entered in sequential order based on the Step Due Date.',
				priority: 1
			}
		};

		(function init() {
			angular.extend($scope, MyStoryConstants['goals'].scope);
			$scope.filters = getDefaultFilters();
			$scope.allowedDateRange = {
				min: "12/12/1900",
				max: "12/12/2099"
			}
		})();

		$scope.$watch("details.goal", function(newVal, oldVal) {
			if (newVal !== oldVal) {
				$scope.goalDateRange = {
					min: newVal.startDate,
					max: newVal.endDate
				};
				if ($scope.form && $scope.form.goalDates) {
					$scope.form.goalDates.$setValidity('dueWithinStartEndDate', !$scope.form.$error.range);
				}
			}
		}, true);

		$scope.$watch("details.goal.note", function(newVal, oldVal, i) {
			if ($scope.details && $scope.details.goal.note) {
				var arr = $scope.details.goal.note.map(function(val) {
					return new Date(val.time);
				});

				var valid = true;
				for (var i = 1; i < arr.length && valid; i++) {
					valid = valid && (arr[i - 1] <= arr[i] || arr[i].toString() == "Invalid Date") &&
						!(arr[i - 1].toString() === "Invalid Date" && arr[i].toString() !== "Invalid Date");
				}

				if ($scope.form && $scope.form.goalDates) {
					$scope.form.goalDates.$setValidity('chronological', valid);
				}
			}
		}, true);

		$scope.newStatus = function(newVal) {
			if (newVal) {
				$scope.details.goal.status = newVal;
				$scope.details.goal.statusDate = new Date();
			}
		};

		$scope.$watch("form.$error.range", function(newVal, oldVal) {
			if ($scope.form && $scope.form.goalDates) {
				$scope.form.goalDates.$setValidity('dueWithinStartEndDate', !newVal);
			}
		}, true);

		function getDefaultFilters() {
			var filters = {};
			filters.status = MyStoryConstants['goals'].scope.defaultStatus;
			return filters;
		}

		$scope.addStep = function() {
			$scope.details.goal.note.push({
				text: null,
				time: null,
				authorString: false
			});
			$timeout(function() {
				focusService.focusElement(angular.element('.step:last .input-text input'));
			});
		};

		$scope.deleteStep = function(index) {
			$scope.details.goal.note.splice(index, 1);
			$timeout(function() {
				focusService.focusElement(angular.element(".step:eq(" + (index === $scope.details.goal.note.length ? index - 1 : index) + ") .input-text input"));
			});
		};

		$scope.addProgress = function() {
			$scope.progress.newProgress = $scope.details.goal.progresses.length > 0 ? $scope.details.goal.progresses[$scope.details.goal.progresses.length - 1].text : 0;
			var
				modalContent = {
					closeButtonText: 'Cancel',
					actionButtonText: 'Save',
					headerText: 'Add Progress',
					bodyContentUrl: 'modules/applets/my-story/pages/goals/entry/goals-entry-progress-modal_template.html',
					data: {
						progress: $scope.progress
					}
				};

			modalService.showModal({}, modalContent).then(function() {
				updateProgressList($scope.progress.newProgress);
			}).finally(function() {
				focusService.focusElement(angular.element('button[ng-click="addProgress()"]'));
			});
		};

		$scope.learnmore = function() {
			var
				modalContent = {
					closeButtonText: 'Close',
					headerText: 'Learn More about SMART Goals',
					bodyContentUrl: 'modules/applets/my-story/pages/goals/entry/goals-entry-learnmore-modal_template.html',
					behavior: {
						correctMessageFocus: function() {
							$timeout(function() {
								focusService.focusElement(angular.element('.alert-success'));
							});
						},
						incorrectMessageFocus: function() {
							$timeout(function() {
								focusService.focusElement(angular.element('.alert-danger'));
							});
						}
					}
				};

			modalService.showModal({}, modalContent).finally(function() {
				focusService.focusElement(angular.element('a[ng-click="learnmore()"]'));
			});
		};

		$scope.allowSavePromise = function() {
			var deferred = $q.defer();
			if ($scope.isGoalCompleted()) {
				$scope.confirmGoalCompletion().then(function() {
					setGoalCompletion();
					deferred.resolve();
				}, function() {
					focusService.focusElement(angular.element('button[ng-click="save()"]:last'));
					deferred.reject();
				});
			} else {
				deferred.resolve();
			}
			return deferred.promise;
		};

		function setGoalCompletion() {
			if ($scope.details.goal.progresses.length === 0 || $scope.details.goal.progresses[$scope.details.goal.progresses.length - 1].text !== "100") {
				updateProgressList(100);
			}
			$scope.details.goal.status = "Complete";
			$scope.details.completedFlag = true;
			$scope.details.reminder.notificationStatus = "Off";
		}

		$scope.isGoalCompleted = function() {
			if (!$scope.details.goal) {
				return false;
			}

			return ($scope.details.goal.progresses && $scope.details.goal.progresses.length > 0 && $scope.details.goal.progresses[$scope.details.goal.progresses.length - 1].text === "100") ||
				$scope.details.goal.status === "Complete" ||

				$scope.details.goal.note.length > 0 && $scope.details.goal.note.every(function(element) {
					return element.authorString === true;
				});
		};

		$scope.confirmGoalCompletion = function() {
			var goalReward = '';
			if($scope.details.goal.extension && $scope.details.goal.extension[0] && $scope.details.goal.extension[0].valueString){
				goalReward = $scope.details.goal.extension[0].valueString;
			}
			var modalOptions = {
				closeButtonText: 'Cancel',
				actionButtonText: 'Submit',
				headerText: 'Confirmation',
				bodyContentUrl: 'modules/applets/my-story/pages/goals/entry/goals-entry-complete-modal_template.html',
				data: {
					reward: goalReward
				}
			};
			$scope.details.goal.statusDate = new Date();
			return modalService.showModal({}, modalOptions);
		};

		function updateProgressList(value) {
			$scope.details.goal.progresses.push({
				time: formatter.getFormattedFrontendDate(new Date()),
				text: value,
				authorString: "progress"
			});
			$scope.details.goal.progresses.splice(0, $scope.details.goal.progresses.length - 3);
		}
	});

});
